<?php

/**
 * @copyright	Copyright (C) 2020 by XiroWeb
 * @license		GNU/GPL
 * */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;

class JFormFieldConfigstyleadmin extends FormField {

	protected $type = 'configstyleadmin';

	protected function getInput() {
        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
		$style = '
                :root, [data-bs-theme=light]{
                    --xiro-ext-input-bg: #ECEFF1;
                }
                [data-bs-theme=dark]{
                    --xiro-ext-input-bg: rgb(48 52 55);
                }
                @media (prefers-color-scheme: dark) { :root {
                    --xiro-ext-input-bg: rgb(48 52 55);

                }}
                .subform-repeatable table{
                    --table-bg: var(--xiro-ext-input-bg);
                }
				.subform-repeatable-group {
					box-shadow: 0 6px 6px rgb(0 0 0 / 7%), 0 6px 6px rgb(0 0 0 / 16%);
					border-radius: 12px;
					padding: 10px;
					background-color: var(--xiro-ext-input-bg);
					margin-bottom: 20px;
					margin-top: 20px;
				}

                select.reset-width {
                    max-width: initial;
                    width: initial;
                    min-width: 100px;
                }
				.subform-repeatable-group .control-label, .subform-repeatable-group .controls {
                    width: 100%;
                }
				.subform-repeatable-group input {
					background-color: var(--xiro-ext-input-bg);
				}
                .field-spacer .control-label {
                    width: 100%; 
                }
                .xirowebspacer label {
                    padding: 0px 0;
                    width: 100%;
                    max-width: 440px;
                }
                .h2 label {
                    font-weight: 700;
                    font-size: 1.35rem;
                }
                .h3 label {
                    font-weight: 700;
                    font-size: 1.15rem;
                }
                .shadow-preview {
                    box-shadow: 0 0rem 3rem rgba(0,0,0,.55)!important;
                }
                .hidden {
                    display: none !important;
                }
                .mod-xirowweb-articles-focus-tags ul.list-inline {
                    display: inline-block;
                }
                .fs-small-1 {
                    font-size: 0.75em;
                }
		';
        $wa->addInlineStyle($style);
		return '';
	}

	protected function getLabel() {
		return '';
	}
}
