<?php

/**
 * @copyright	Copyright (C) 2020 by XiroWeb
 * @license		GNU/GPL
 * */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;


class JFormFieldDivstartend extends FormField {

	protected $type = 'divstartend';

    protected $renderLayout = 'renderfield_div';

    protected $basePath = JPATH_SITE . '/modules/' . 'mod_xiroweb_articles_focus' . '/layouts';

    protected function getInput()
	{
		return ' ';
	}

	protected function getLabel() {
        return ' ';
	}

    protected function getTitle()
	{
		return $this->getLabel();
	}

    public function renderField($options = array())
	{
        $options['divpos'] = $this->element['divpos'] ? (string) $this->element['divpos'] : '';

		return parent::renderField($options);
	}

    protected function getRenderer($layoutId = 'default')
	{
		$renderer = new FileLayout($layoutId, $this->basePath);

		$renderer->setDebug($this->isDebugEnabled());

		return $renderer;
	}

}
