<?php
/**
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;

defined('_JEXEC') or die;

extract($displayData);

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->useScript('showon');

?>

    <div class="card shadow-preview">
        <?php 
            $rel           = ' data-showon=\'' .
            json_encode(FormHelper::parseShowOnConditions('show_image:1', 'jform', 'params')) . '\'';
        ?>
    <div class="d-flex align-items-center justify-content-center  bg-info bg-opacity-50 text-center" style="height:180px" <?php echo $rel; ?>>
            <?php 
                $rel           = ' data-showon=\'' .
                json_encode(FormHelper::parseShowOnConditions('link_intro_image:1[AND]show_image:1', 'jform', 'params')) . '\'';
            ?>
            <div class ="m-1" <?php echo $rel; ?>>
                <i  class="fas fa-link"></i>
            </div>
            <div>
                <?php echo Text::_('MOD_XIROWEB_ARTICLES_FOCUS_FIELD_PREVIEW_IMAGE'); ?>
            </div>
 
    </div>
        <div class="card-body">
           
            <div>
            <?php 
                $rel           = ' data-showon=\'' .
                json_encode(FormHelper::parseShowOnConditions('show_date:1', 'jform', 'params')) . '\'';
            ?>
            <span class="badge bg-light text-dark border m-1 ms-0 fw-light fs-small-1" <?php echo $rel; ?>>
                <i class="far fa-calendar-alt"></i>
                <?php echo Text::_('MOD_XIROWEB_ARTICLES_FOCUS_FIELD_PREVIEW_DATE'); ?>
            </span>
            <?php 
                $rel           = ' data-showon=\'' .
                json_encode(FormHelper::parseShowOnConditions('show_category:1', 'jform', 'params')) . '\'';
            ?>
            <span class="badge bg-light text-dark border m-1 ms-0 fw-light fs-small-1" <?php echo $rel; ?>>
                <i  class="fas fa-folder"></i>
                <?php echo Text::_('JCATEGORY'); ?>
            </span>
            <?php 
                $rel           = ' data-showon=\'' .
                json_encode(FormHelper::parseShowOnConditions('show_hits:1', 'jform', 'params')) . '\'';
            ?>
            <span class="badge bg-light text-dark border m-1 ms-0 fw-light fs-small-1" <?php echo $rel; ?>>
                <i class="fas fa-chart-line"></i>
                <?php echo Text::_('MOD_XIROWEB_ARTICLES_FOCUS_FIELD_PREVIEW_HIT'); ?>
            </span>
            <?php 
                $rel           = ' data-showon=\'' .
                json_encode(FormHelper::parseShowOnConditions('show_author:1', 'jform', 'params')) . '\'';
            ?>
            <span class="badge bg-light text-dark border m-1 ms-0 fw-light fs-small-1" <?php echo $rel; ?>>
                <i  class="far fa-user"></i>
                <?php echo Text::_('MOD_XIROWEB_ARTICLES_FOCUS_FIELD_PREVIEW_AUTHOR'); ?>
            </span>
            <?php 
                $rel           = ' data-showon=\'' .
                json_encode(FormHelper::parseShowOnConditions('show_tags:1', 'jform', 'params')) . '\'';
            ?>
            <span class="badge bg-light text-dark border m-1 ms-0 fw-light fs-small-1" <?php echo $rel; ?>>
                <i  class="fas fa-tags"></i>
                <?php echo Text::_('MOD_XIROWEB_ARTICLES_FOCUS_FIELD_PREVIEW_TAGS'); ?>
            </span>
            </div>
            <h3>
                    <?php 
                        $rel           = ' data-showon=\'' .
                        json_encode(FormHelper::parseShowOnConditions('link_titles:1', 'jform', 'params')) . '\'';
                    ?>
                    <span <?php echo $rel; ?>>
                                <i  class="fas fa-link"></i>
                    </span>
                    <?php echo Text::_('MOD_XIROWEB_ARTICLES_FOCUS_FIELD_PREVIEW_TITLE'); ?>
            </h3>
            <?php 
                $rel           = ' data-showon=\'' .
                json_encode(FormHelper::parseShowOnConditions('show_introtext:1', 'jform', 'params')) . '\'';
            ?>
            <p class="" <?php echo $rel; ?>>
                <?php echo Text::_('MOD_XIROWEB_ARTICLES_FOCUS_FIELD_PREVIEW_INTROTEXT'); ?>
                <span>...</span>
            </p>
            <?php 
                $rel           = ' data-showon=\'' .
                json_encode(FormHelper::parseShowOnConditions('show_readmore:1', 'jform', 'params')) . '\'';
                ?>
            <div <?php echo $rel; ?>>
                <a class="btn btn-info" role="button" aria-disabled="true"><?php echo Text::_('MOD_XIROWEB_ARTICLES_FOCUS_FIELD_PREVIEW_READMORE'); ?></a>
            </div>

            
        </div>
    </div>
