<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_templates
 *
 * @copyright   Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('behavior.formvalidator');
JHtml::_('behavior.keepalive');
JHtml::_('formbehavior.chosen', 'select');
$user = JFactory::getUser();

JHtml::_('script', 'customize-template.js', array('version' => 'auto', 'relative' => true));
JHtml::_('stylesheet', 'customize-template.css', array('version' => 'auto', 'relative' => true));

JFactory::getDocument()->addScriptDeclaration("
	Joomla.submitbutton = function(task)
	{
		if (task == 'style.cancel' || document.formvalidator.isValid(document.getElementById('style-form'))) {
			Joomla.submitform(task, document.getElementById('style-form'));
		}
	};
");

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

// for crate module
$app = JFactory::getApplication('administrator');
$app->setUserState('com_modules.modules.client_id', $this->item->client_id);

if ($this->item->client_id == '0') {
	
	$iframeHtml = '<iframe class="preview" src="' . JUri::root() . 'index.php?templateStyle=' . (int) $this->item->id. '"></iframe>';
	$script[] = "jQuery(document).ready(function($) {";
		$script[] = "       var xiro_template_preview = $(this).find('#xiro-customize-preview');";
		$script[] = "       xiro_template_preview.find('iframe').remove();";
		$script[] = "       xiro_template_preview.prepend('" . trim($iframeHtml) . "');";

		$script[] = "       var xiro_template_preview = $(this).find('#xiro-customize-preview');";
		
		$script[] = "});";	
		
		JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));
}
?>
<div id="xiro-full-overlay" class=" expanded">
<form action="<?php echo JRoute::_('index.php?option=com_templates&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="style-form" class="form-validate w-normal">

	<?php echo JLayoutHelper::render('joomla.edit.title_alias', $this); ?>
	<div class="text-right">
		<?php if ($this->item->client_id == '0') : ?>
			<?php if (ComponentHelper::getParams('com_templates')->get('template_positions_display')) : ?>
			<?php
				$selector_viewlayout = 'ModalSelectviewlayout-'.$this->item->id;
				$layoutData_viewlayout = array(
					'selector' => $selector_viewlayout,
					'body'	   => '',
					'params'   => array(
						'title'       => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_VIEW_LAYOUT'). ' ' . $this->escape($this->item->title),
						'url'         => JUri::root() . 'index.php?tp=1&positionmodal=1&templateStyle=' . (int) $this->item->id,
						'modalxiro'  => true	
					)
				);
				echo JLayoutHelper::render('xiroadmin.xiromodalbutton',array(
					'selector' => $selector_viewlayout,
					'class'	=> 'btn btn-primary',
					'icon' => 'fa fa-fw fa-object-group',
					'title' => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_VIEW_LAYOUT')
				));
				echo JLayoutHelper::render('xiroadmin.xiromodal', $layoutData_viewlayout); ?>
			<?php
				$selector_addmodule = 'ModalSelectaddmodule-'.$this->item->id;
				$layoutData_addmodule = array(
					'selector' => $selector_addmodule,
					'body'	   => '',
					'params'   => array(
						'title'       => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_ADD_MODULE_MODAL_TITLE'). ' ' . $this->escape($this->item->title),
						'url'         => JUri::base() . 'index.php?option=com_modules&tmpl=component&view=select&templateStyle=' . (int) $this->item->id . '&roottemplate=' . (string) $this->item->template,
						'modalxiro'  => true	
					)
				);
				echo JLayoutHelper::render('xiroadmin.xiromodalbutton',array(
					'selector' => $selector_addmodule,
					'class'	=> 'btn btn-primary',
					'icon' => 'fa fa-fw fa-calendar-plus-o',
					'title' => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_ADD_MODULE_BTN')
				));
				echo JLayoutHelper::render('xiroadmin.xiromodal', $layoutData_addmodule); ?>
				<?php
				$selector_modulemanager = 'ModalSelectmodulemanager-'.$this->item->id;
				$layoutData_modulemanager = array(
					'selector' => $selector_modulemanager,
					'body'	   => '',
					'params'   => array(
						'title'       => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_MANAGER_MODULE_MODAL_TITLE'). ' ' . $this->escape($this->item->title),
						'url'         => JUri::base() . 'index.php?option=com_modules&tmpl=component&templateStyle=' . (int) $this->item->id . '&roottemplate=' . (string) $this->item->template,
						'modalxiro'  => true	
					)
				);
				echo JLayoutHelper::render('xiroadmin.xiromodalbutton',array(
					'selector' => $selector_modulemanager,
					'class'	=> 'btn btn-primary',
					'icon' => 'menu-module fa fa-cubes',
					'title' => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_MANAGER_MODULE_BTN')
				));
				echo JLayoutHelper::render('xiroadmin.xiromodal', $layoutData_modulemanager); ?>
			<?php endif; ?>
		<?php endif; ?>
	</div>

	<div class="form-vertical">
		<?php
		echo JHtml::_('bootstrap.startAccordion', 'templateStyleedit', array('active' => 'none',  'parent' => 'true'));
		$i = 0;
		echo JHtml::_('bootstrap.addSlide', 'templateStyleedit', JText::_('JDETAILS'), 'collapse' . ($i++));
		?>

		<div class="row-fluid">
			<div class="span12">
				<h2>
					<?php echo JText::_($this->item->template); ?>
				</h2>
				<div class="info-labels">
					<span class="label hasTooltip" title="<?php echo JHtml::_('tooltipText', 'COM_TEMPLATES_FIELD_CLIENT_LABEL'); ?>">
						<?php echo $this->item->client_id == 0 ? JText::_('JSITE') : JText::_('JADMINISTRATOR'); ?>
					</span>
				</div>
				<div>
					<p><?php echo JHtml::_('string.truncate', JText::_($this->item->xml->description), '180','',false); ?></p>
					<?php
					$selector_viewsite = 'ModalSelectViewSite-readmoredesc';
					$layoutData_viewsite = array(
						'selector' => $selector_viewsite,
						'body'	   => '<div class="modalcontent">' . JText::_($this->item->xml->description) . '</div>',
						'params'   => array(
							'title'       => JText::_('JGLOBAL_FIELDSET_DESCRIPTION'). ' ' . $this->escape($this->item->title),
							'modalxiro'  => true											
						)
					);
					echo JLayoutHelper::render('xiroadmin.xiromodalbutton',array(
						'selector' => $selector_viewsite,
						'class'	=> 'btn btn-primary',
						'icon' => 'fa fa-eye',
						'title' => JText::_('JGLOBAL_SHOW_FULL_DESCRIPTION')
					));
					echo JLayoutHelper::render('xiroadmin.xiromodal', $layoutData_viewsite); ?>
				</div>
				<?php
				$this->fieldset = 'basic';
				$html = JLayoutHelper::render('joomla.edit.fieldset', $this);
				echo $html ? '<hr />' . $html : '';
				?>
			</div>
			<div class="hidden">
				<?php
				// Set main fields.
				$this->fields = array(
					'home',
					'client_id',
					'template'
				);
				?>
				<?php echo JLayoutHelper::render('joomla.edit.global', $this); ?>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endSlide'); ?>


		<?php
		$this->fieldsets = array();
		$this->ignore_fieldsets = array('basic', 'description');
		$this->collapse_parent = 'templateStyleedit';
		echo JLayoutHelper::render('xiroadmin.edit.paramscollapse', $this);
		?>

		<?php if ($user->authorise('core.edit', 'com_menus') && $this->item->client_id == 0 && $this->canDo->get('core.edit.state')) : ?>
			<?php
				$selector_assignment = 'ModalSelectViewSite-assignment';
				$layoutData_assignment = array(
					'selector' => $selector_assignment,
					'body'	   => '<div class="modalcontent">' . $this->loadTemplate('assignment') . '</div>',
					'params'   => array(
						'title'       => JText::_('COM_TEMPLATES_MENUS_ASSIGNMENT'). ' ' . $this->escape($this->item->title),
						'modalxiro'  => true											
					)
				);
				echo JLayoutHelper::render('xiroadmin.xiromodalbutton',array(
					'selector' => $selector_assignment,
					'class'	=> 'btn-panel-customize',
					'icon' => 'assignment',
					'title' => JText::_('COM_TEMPLATES_MENUS_ASSIGNMENT')
				));
				echo JLayoutHelper::render('xiroadmin.xiromodal', $layoutData_assignment); ?>
		<?php endif; ?>

		<?php echo JHtml::_('bootstrap.endAccordion'); ?>

		<input type="hidden" name="task" value="" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
	<div id="customize-footer-actions" class="xiro-overlay-footer">
		<button type="button" class="collapse-sidebar button" aria-expanded="true" aria-label="Hide Controls">
			<span class="collapse-sidebar-arrow">&nbsp;</span>
			<span class="collapse-sidebar-label"><?php echo JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_PANEL_SHOW_HIDE'); ?></span>
		</button>
		<div class="devices-wrapper">
			<div class="devices">
				<button type="button" class="preview-desktop" aria-pressed="1" data-device="desktop">
					<span class="icon-screen">&nbsp;</span>
				</button>
				<button type="button" class="preview-tablet" aria-pressed="" data-device="tablet">
					<span class="icon-tablet">&nbsp;</span>
				</button>
				<button type="button" class="preview-mobile" aria-pressed="" data-device="mobile">
					<span class="icon-mobile">&nbsp;</span>
				</button>
			</div>
		</div>
		<div class="panelcontrols-wrapper">
			<div class="panelcontrols">
				<button type="button" class="panelsize" data-size="normal" >
					<span class="icon-expand-2">&nbsp;</span>
				</button>
			</div>
		</div>
	</div>
</form>
	<div id="xiro-customize-preview" class="">
		
	</div>
</div>
