<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_modules
 *
 * @copyright   Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$data = $displayData['data']['view'];
$position = $displayData['selectposition'];
JLoader::register('TemplatesHelper', JPATH_ADMINISTRATOR . '/components/com_templates/helpers/templates.php');

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
$clientId       = $data->clientId;
$state          = 1;
// $selectedPosition = $data->position;
$selectedPosition = $position;
$positionpre = JHtml::_('modules.positions', $clientId, $state, $selectedPosition);
$positions = array();

$app = JFactory::getApplication();
$roottemplate = $app->input->get('roottemplate', '', 'STRING');
if ($roottemplate) {
	$positions[''] =  $positionpre[''];
	$positions[$roottemplate] = $positionpre[$roottemplate];

	JFactory::getLanguage()->load('plg_system_xiroadmin',JPATH_SITE);
	$value = '';
	$templatestyle = $app->getUserState('com_modules.module.templatestyle', 0); 
	$thisid = 'filter_position';
	$modalId = 'Moduleadmin_' . $thisid;


	// Add the modal field script to the document head.
	JHtml::_('jquery.framework');
	JHtml::_('script', 'system/modal-fields.js', array('version' => 'auto', 'relative' => true));

	// our callback function from the modal to the main window:
	JFactory::getDocument()->addScriptDeclaration("
		function jSelectModuleadmin_" . $thisid . "(id, title, catid, object, url, language) {
			window.processModalSelect('Moduleadmin', '" . $thisid . "', id, title, catid, object, url, language);
			form = document.getElementById('adminForm');
			form.submit();
		}
		");

	$title = empty($value) ? '' : htmlspecialchars($value, ENT_QUOTES, 'UTF-8');	
	$html  = '<span class="input-append">';
	$html .= '<input class="input-medium" id="' . $thisid . '_name" type="hidden" value="' . $title . '" disabled="disabled" size="35" />';

	// html for the Select button
	$html .= '<a'
		. ' class="btn hasTooltip' . ($value ? ' hidden' : '') . '"'
		. ' id="' . $thisid . '_select"'
		. ' data-toggle="modal"'
		. ' role="button"'
		. ' href="#ModalSelect' . $modalId . '"'
		. ' title="' . JHtml::tooltipText('PLG_SYSTEM_XIROADMIN_FIELD_POSITION_SELECT_BUTTON_TOOLTIP') . '">'
		. '<span class="icon-file" aria-hidden="true"></span> ' . JText::_('PLG_SYSTEM_XIROADMIN_JSELECT')
		. '</a>';

	// html for the Clear button
	$html .= '<a'
		. ' class="btn' . ($value ? '' : ' hidden') . '"'
		. ' id="' . $thisid . '_clear"'
		. ' href="#"'
		. ' onclick="window.processModalParent(\'' . $thisid . '\'); return false;">'
		. '<span class="icon-remove" aria-hidden="true"></span>' . JText::_('PLG_SYSTEM_XIROADMIN_JCLEAR')
		. '</a>';

	$html .= '</span>';

	// url for the iframe
	$linkModuleadmins = JUri::root().'index.php?tp=1&positionmodal=1&amp;' . JSession::getFormToken() . '=1';


	if ($templatestyle) {
		$linkModuleadmins .= '&templateStyle=' . $templatestyle;
	}

	$urlSelect = $linkModuleadmins . '&amp;function=jSelectModuleadmin_' . $thisid;

	// title to go in the modal header
	$modalTitle    = JText::_('PLG_SYSTEM_XIROADMIN_SELECT_MODAL_TITLE');

	// html to set up the modal iframe
	$html .= JHtml::_(
		'bootstrap.renderModal',
		'ModalSelect' . $modalId,
		array(
			'title'       => $modalTitle,
			'url'         => $urlSelect,
			'height'      => '400px',
			'width'       => '100%',
			'bodyHeight'  => '70',
			'modalWidth'  => '100',
			'footer'      => '<a role="button" class="btn" data-dismiss="modal" aria-hidden="true">' . JText::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</a>',
		)
	);
	echo $html;
	// css more
	JFactory::getDocument()->addStyleDeclaration('.js-stools-field-filter {
	    border: 1px dashed #000;
	    padding: 2px 5px;
	    border-radius: 4px;
	}');

} else {
	$positions = $positionpre;
}

$customGroupText = JText::_('COM_MODULES_CUSTOM_POSITION');


$attr = array(
	'id'          => 'filter_position_id',
    'list.select' => $selectedPosition,
    'list.attr'   => 'class="chzn-custom-value" '
    . 'onchange="this.form.submit();" '
	. 'data-custom_group_text="' . $customGroupText . '" '
	. 'data-no_results_text="' . JText::_('COM_MODULES_ADD_CUSTOM_POSITION') . '" '
	. 'data-placeholder="' . JText::_('COM_MODULES_TYPE_OR_SELECT_POSITION') . '" '
);

echo JHtml::_('select.groupedlist', $positions, 'filter[position]', $attr);
