<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_templates
 *
 * @copyright   (C) 2009 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('behavior.formvalidator');
JHtml::_('behavior.keepalive');
JHtml::_('formbehavior.chosen', 'select');
$user = JFactory::getUser();

JFactory::getDocument()->addScriptDeclaration("
	Joomla.submitbutton = function(task)
	{
		if (task == 'style.cancel' || document.formvalidator.isValid(document.getElementById('style-form'))) {
			Joomla.submitform(task, document.getElementById('style-form'));
		}
	};
");
?>

<form action="<?php echo JRoute::_('index.php?option=com_templates&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="style-form" class="form-validate">

	<?php echo JLayoutHelper::render('joomla.edit.title_alias', $this); ?>

	<div class="text-left">
		<?php if ($this->item->client_id == '0') : ?>
			<?php if (JComponentHelper::getParams('com_templates')->get('template_positions_display')) : ?>
				<?php
					$selector_viewlayout = 'ModalSelectviewlayout-'.$this->item->id;
					$layoutData_viewlayout = array(
						'selector' => $selector_viewlayout,
						'body'	   => '',
						'params'   => array(
							'title'       => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_VIEW_LAYOUT'). ' ' . $this->escape($this->item->title),
							'url'         => JUri::root() . 'index.php?tp=1&positionmodal=1&templateStyle=' . (int) $this->item->id,
							'modalxiro'  => true	
						)
					);
					echo JLayoutHelper::render('xiroadmin.xiromodalbutton',array(
						'selector' => $selector_viewlayout,
						'class'	=> 'btn btn-primary',
						'icon' => 'fa fa-fw fa-object-group',
						'title' => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_VIEW_LAYOUT')
					));
					echo JLayoutHelper::render('xiroadmin.xiromodal', $layoutData_viewlayout); ?>
				<?php
					$selector_addmodule = 'ModalSelectaddmodule-'.$this->item->id;
					$layoutData_addmodule = array(
						'selector' => $selector_addmodule,
						'body'	   => '',
						'params'   => array(
							'title'       => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_ADD_MODULE_MODAL_TITLE'). ' ' . $this->escape($this->item->title),
							'url'         => JUri::base() . 'index.php?option=com_modules&tmpl=component&view=select&templateStyle=' . (int) $this->item->id . '&roottemplate=' . (string) $this->item->template,
							'modalxiro'  => true	
						)
					);
					echo JLayoutHelper::render('xiroadmin.xiromodalbutton',array(
						'selector' => $selector_addmodule,
						'class'	=> 'btn btn-primary',
						'icon' => 'fa fa-fw fa-calendar-plus-o',
						'title' => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_ADD_MODULE_BTN')
					));
					echo JLayoutHelper::render('xiroadmin.xiromodal', $layoutData_addmodule); ?>
				<?php
					$selector_modulemanager = 'ModalSelectmodulemanager-'.$this->item->id;
					$layoutData_modulemanager = array(
						'selector' => $selector_modulemanager,
						'body'	   => '',
						'params'   => array(
							'title'       => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_MANAGER_MODULE_MODAL_TITLE'). ' ' . $this->escape($this->item->title),
							'url'         => JUri::base() . 'index.php?option=com_modules&tmpl=component&templateStyle=' . (int) $this->item->id . '&roottemplate=' . (string) $this->item->template,
							'modalxiro'  => true	
						)
					);
					echo JLayoutHelper::render('xiroadmin.xiromodalbutton',array(
						'selector' => $selector_modulemanager,
						'class'	=> 'btn btn-primary',
						'icon' => 'menu-module fa fa-cubes',
						'title' => JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_MANAGER_MODULE_BTN')
					));
					echo JLayoutHelper::render('xiroadmin.xiromodal', $layoutData_modulemanager); ?>
				<?php
					$selector_preview = 'ModalSelectviewlayout-'.$this->item->id;
					$layoutData_preview = array(
						'selector' => $selector_preview,
						'body'	   => '',
						'params'   => array(
							'title'       => JText::_('COM_TEMPLATES_TEMPLATE_PREVIEW'). ' ' . $this->escape($this->item->title),
							'url'         => JUri::root() . 'index.php?templateStyle=' . (int) $this->item->id,
							'modalxiro'  => true	
						)
					);
					echo JLayoutHelper::render('xiroadmin.xiromodalbutton',array(
						'selector' => $selector_preview,
						'class'	=> 'btn btn-primary',
						'icon' => 'fa fa-eye',
						'title' => JText::_('COM_TEMPLATES_TEMPLATE_PREVIEW')
					));
					echo JLayoutHelper::render('xiroadmin.xiromodal', $layoutData_preview); ?>
			<?php endif; ?>
		<?php endif; ?>
	</div>

	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'details')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'details', JText::_('JDETAILS')); ?>

		<div class="row-fluid">
			<div class="span9">
				<h2>
					<?php echo JText::_($this->item->template); ?>
				</h2>
				<div class="info-labels">
					<span class="label hasTooltip" title="<?php echo JHtml::_('tooltipText', 'COM_TEMPLATES_FIELD_CLIENT_LABEL'); ?>">
						<?php echo $this->item->client_id == 0 ? JText::_('JSITE') : JText::_('JADMINISTRATOR'); ?>
					</span>
				</div>
				<div>
					<p><?php echo JText::_($this->item->xml->description); ?></p>
					<?php
					$this->fieldset = 'description';
					$description = JLayoutHelper::render('joomla.edit.fieldset', $this);
					?>
					<?php if ($description) : ?>
						<p class="readmore">
							<a href="#" onclick="jQuery('.nav-tabs a[href=\'#description\']').tab('show');">
								<?php echo JText::_('JGLOBAL_SHOW_FULL_DESCRIPTION'); ?>
							</a>
						</p>
					<?php endif; ?>
				</div>
				<?php
				$this->fieldset = 'basic';
				$html = JLayoutHelper::render('joomla.edit.fieldset', $this);
				echo $html ? '<hr />' . $html : '';
				?>
			</div>
			<div class="span3">
				<?php
				// Set main fields.
				$this->fields = array(
					'home',
					'client_id',
					'template'
				);
				?>
				<?php echo JLayoutHelper::render('joomla.edit.global', $this); ?>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php if ($description) : ?>
			<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'description', JText::_('JGLOBAL_FIELDSET_DESCRIPTION')); ?>
			<?php echo $description; ?>
			<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php endif; ?>

		<?php
		$this->fieldsets = array();
		$this->ignore_fieldsets = array('basic', 'description');
		echo JLayoutHelper::render('joomla.edit.params', $this);
		?>

		<?php if ($user->authorise('core.edit', 'com_menus') && $this->item->client_id == 0 && $this->canDo->get('core.edit.state')) : ?>
			<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'assignment', JText::_('COM_TEMPLATES_MENUS_ASSIGNMENT')); ?>
			<?php echo $this->loadTemplate('assignment'); ?>
			<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php endif; ?>

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>

		<input type="hidden" name="task" value="" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
</form>
