<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_templates
 *
 * @copyright   (C) 2008 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @copyright   (C) 2021 XiroWeb Ltd. <https://www.xiroweb.com>
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Component\ComponentHelper;


HTMLHelper::_('behavior.formvalidator');
HTMLHelper::_('behavior.keepalive');

$app = Factory::getApplication();
// $app->setUserState('com_modules.modules.client_id', $this->item->client_id);


$this->useCoreUI = true;
$wa = $this->document->getWebAssetManager();

$wa->registerAndUseStyle('xiroadmin.templateedit', 'customize-template.css');

HTMLHelper::_('Jquery.framework');
$wa->registerAndUseScript('xiroadmin.templateedit', 'customize-template.js', ['relative' => true, 'version' => 'auto'], []);
$wa->registerAndUseScript('xiroadmin.style-menu-assignment-select', 'com_templates/style-menu-assignment-select.js', ['relative' => true, 'version' => 'auto'], []);

$user = Factory::getUser();
		if ($this->item->client_id == '0') {
			$iframeHtml = '<iframe class="preview" src="' . Uri::root() . 'index.php?templateStyle=' . (int) $this->item->id. '"></iframe>';
		} elseif ($this->item->client_id == '1') {

			if ($this->item->home == '1') {
				$iframeHtml = '<iframe class="preview" src="' . Uri::base() . 'index.php"></iframe>';
			} else {
				$iframeHtml = '<div class="alert alert-danger xiroadmin-box-shadow-3">' . Text::_('TPL_XIROADMIN_PREVIEW_ADMINISTRATOR_NONE_SUPPORT') . '</div>';
			}

		}
		$script[] = "jQuery(document).ready(function($) {";
		$script[] = "       var xiro_template_preview = $(this).find('#xiro-customize-preview');";
		$script[] = "       xiro_template_preview.find('iframe').remove();";
		$script[] = "       xiro_template_preview.prepend('" . trim($iframeHtml) . "');";

		$script[] = "       var xiro_template_preview = $(this).find('#xiro-customize-preview');";

		$script[] = "});";

		// JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));
		$wa->addInlineScript(implode("\n", $script), [], []);

	$client = (int) $this->item->client_id === 1 ? 'administrator' : 'site';
?>
<div id="xiro-full-overlay" class=" expanded">
	<form action="<?php echo Route::_('index.php?option=com_templates&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="style-form" aria-label="<?php echo Text::_('COM_TEMPLATES_STYLE_FORM_EDIT'); ?>" class="form-validate w-normal">

		<?php echo LayoutHelper::render('joomla.edit.title_alias', $this); ?>

		<div class="text-end">
			<?php if ($this->item->client_id == '0') : ?>
				<?php
					$selector_viewlayout = 'ModalSelectviewlayout-'.$this->item->id;
					echo LayoutHelper::render('xiroadmin.xiromodalbutton',
						array(
							'selector' => $selector_viewlayout,
							'class'	=> 'btn btn-xiroadmin btn-raised mb-2 btn-sm',
							'icon' => 'fa fa-fw fa-object-group',
							'title' => Text::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_VIEW_LAYOUT')
						)
					);
					echo HTMLHelper::_(
						'bootstrap.renderModal',
						$selector_viewlayout,
						array(
							'url' 		  => Route::link($client, 'index.php?tp=1&templateStyle=' . (int) $this->item->id),
							'title'       => Text::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_VIEW_LAYOUT'),
							'backdrop'    => 'static',
							'height'      => '1000px',
							'width'       => '800px',
							'bodyHeight'  => 90,
							'modalWidth'  => 90,
							'footer'      => '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">'
									. Text::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>',
						)
					);
				?>
				<?php
				if (ComponentHelper::getParams('com_templates')->get('template_positions_display')) {

					$selector_addmodule = 'ModalSelectaddmodule-'.$this->item->id;
					echo LayoutHelper::render('xiroadmin.xiromodalbutton',
						array(
							'selector' => $selector_addmodule,
							'class'	=> 'btn btn-xiroadmin btn-raised mb-2 btn-sm',
							'icon' => 'far fa-calendar-plus',
							'title' => Text::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_ADD_MODULE_BTN')
						)
					);
					echo HTMLHelper::_(
						'bootstrap.renderModal',
						$selector_addmodule,
						array(
							'url' 		  => Route::link('administrator', 'index.php?option=com_modules&tmpl=component&view=select&templateStyle=' . (int) $this->item->id . '&roottemplate=' . (string) $this->item->template),
							'title'       => Text::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_ADD_MODULE_MODAL_TITLE'),
							'backdrop'    => 'static',
							'height'      => '1000px',
							'width'       => '800px',
							'bodyHeight'  => 90,
							'modalWidth'  => 90,
							'footer'      => '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">'
									. Text::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>',
						)
					);

					$selector_modulemanager = 'ModalSelectmodulemanager-'.$this->item->id;
					echo LayoutHelper::render('xiroadmin.xiromodalbutton',
						array(
							'selector' => $selector_modulemanager,
							'class'	=> 'btn btn-xiroadmin btn-raised mb-2 btn-sm',
							'icon' => 'fa fa-cubes',
							'title' => Text::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_MANAGER_MODULE_BTN')
						)
					);
					echo HTMLHelper::_(
						'bootstrap.renderModal',
						$selector_modulemanager,
						array(
							'url' 		  => Route::link('administrator', 'index.php?option=com_modules&tmpl=component&templateStyle=' . (int) $this->item->id . '&roottemplate=' . (string) $this->item->template),
							'title'       => Text::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_MANAGER_MODULE_MODAL_TITLE') . ' ' . $this->escape($this->item->title),
							'backdrop'    => 'static',
							'height'      => '1000px',
							'width'       => '800px',
							'bodyHeight'  => 90,
							'modalWidth'  => 90,
							'footer'      => '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">'
									. Text::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>',
						)
					);
				}
				?>

			<?php endif; ?>
		</div>

		<div class="form-vertical">
			<?php //echo HTMLHelper::_('uitab.startTabSet', 'myTab', ['active' => 'details', 'recall' => true, 'breakpoint' => 768]); ?>

			<?php // echo HTMLHelper::_('uitab.addTab', 'myTab', 'details', Text::_('JDETAILS')); ?>
			<?php
				$this->collapse_parent = 'templateStyleedit';
				echo HTMLHelper::_('bootstrap.startAccordion', $this->collapse_parent, array('active' => 'none',  'parent' => 'true'));
				$i = 0;
				echo HTMLHelper::_('bootstrap.addSlide', $this->collapse_parent, Text::_('JDETAILS'), 'collapse' . ($i++));
				?>

			<div class="row">
				<div class="col-12">
					<h2>
						<?php echo Text::_($this->item->template); ?>
					</h2>
					<div class="info-labels">
						<span class="badge bg-secondary">
							<?php echo $this->item->client_id == 0 ? Text::_('JSITE') : Text::_('JADMINISTRATOR'); ?>
						</span>
					</div>
					<div>

						<?php
						$this->fieldset = 'description';
						$long_description  = LayoutHelper::render('joomla.edit.fieldset', $this);
						$short_description = Text::_($this->item->xml->description);
						if (!$long_description)
						{
							$truncated = HTMLHelper::_('string.truncate', $short_description, 550, true, false);

							if (strlen($truncated) > 500)
							{
								$long_description  = $short_description;
								$short_description = HTMLHelper::_('string.truncate', $truncated, 250);

								if ($short_description == $long_description)
								{
									$long_description = '';
								}
							}
						}

						?>
						<p><?php echo $short_description; ?></p>
						<?php if ($long_description) : ?>

							<?php
								$selector_desc = 'Modal-desc';
								echo LayoutHelper::render('xiroadmin.xiromodalbutton',
									array(
										'selector' => $selector_desc,
										'class'	=> 'btn btn-warning btn-sm',
										'icon' => 'fa fa-eye',
										'title' => Text::_('JGLOBAL_SHOW_FULL_DESCRIPTION')
									)
								);
								echo HTMLHelper::_(
									'bootstrap.renderModal',
									$selector_desc,
									array(
										'title'       => Text::_('JGLOBAL_SHOW_FULL_DESCRIPTION'),
										'backdrop'    => 'static',
										'height'      => '1000px',
										'width'       => '800px',
										'bodyHeight'  => 90,
										'modalWidth'  => 90,
										'footer'      => '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">'
												. Text::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>',
									),
									'<div class="modalcontent">' . $long_description . '</div>'
								);
							?>
						<?php endif; ?>
					</div>
					<?php
					$this->fieldset = 'basic';
					$html = LayoutHelper::render('joomla.edit.fieldset', $this);
					echo $html ? '<hr>' . $html : '';
					?>
				</div>

				<div class="col-12">
					<?php
					// Set main fields.
					$this->fields = array(
						'client_id',
						'template'
					);
					?>
					<?php echo LayoutHelper::render('joomla.edit.global', $this); ?>
				</div>
			</div>
			<?php //echo HTMLHelper::_('uitab.endTab'); ?>
			<?php echo HTMLHelper::_('bootstrap.endSlide'); ?>


			<?php
			$this->fieldsets = array();
			$this->ignore_fieldsets = array('basic', 'description');
			echo LayoutHelper::render('xiroadmin.edit.paramscollapse', $this);
			?>

			<?php if ($user->authorise('core.edit', 'com_menus') && $this->item->client_id == 0 && $this->canDo->get('core.edit.state')) : ?>
				<?php // echo HTMLHelper::_('uitab.addTab', 'myTab', 'assignment', Text::_('COM_TEMPLATES_MENUS_ASSIGNMENT'));
					echo HTMLHelper::_('bootstrap.addSlide', $this->collapse_parent, Text::_('COM_TEMPLATES_MENUS_ASSIGNMENT'), 'collapse' . ($i++));
				?>

						<?php
						// Set main fields.
						$this->fields = array(
							'home'
						);
						?>
						<?php // echo LayoutHelper::render('joomla.edit.global', $this); ?>
						<?php  echo LayoutHelper::render('xiroadmin.com_templates.fieldhome', $this); ?>

						<div id="style-edit-menu-assignment-all" class="px-2 py-4 m-2 xiroadmin-box-shadow-3 bg-success text-white <?php echo $this->item->home ? '' : 'hidden';   ?>">
							<?php echo Text::_('TPL_XIROADMIN_COM_TEMPLATES_STYLE_EDIT_IS_DEFAULT_ALL'); ?>
						</div>


					<?php
						$selector_assignment = 'ModalSelectViewSite-assignment';
						echo LayoutHelper::render('xiroadmin.xiromodalbutton',
							array(
								'selector' => $selector_assignment,
								'class'	=> 'btn btn-warning btn-raised mt-2' . ($this->item->home ? ' hidden' : '') ,
								'id' 	=> 'style-edit-menu-assignment-button',
								'icon' => 'fa fa-sitemap',
								'title' => Text::_('COM_TEMPLATES_MENUS_ASSIGNMENT')
							)
						);
						echo HTMLHelper::_(
							'bootstrap.renderModal',
							$selector_assignment,
							array(
								'title'       => Text::_('COM_TEMPLATES_MENUS_ASSIGNMENT'). ' ' . Text::_('COM_TEMPLATES_MENUS_ASSIGNMENT'),
								'backdrop'    => 'static',
								'height'      => '1000px',
								'width'       => '800px',
								'bodyHeight'  => 90,
								'modalWidth'  => 90,
								'footer'      => '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">'
										. Text::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>',
							),
							'<div class="modalcontent">' . $this->loadTemplate('assignment') . '</div>'
						);
					?>
				<?php echo HTMLHelper::_('bootstrap.endSlide'); ?>

			<?php endif; ?>

			<?php //echo HTMLHelper::_('uitab.endTabSet'); ?>
			<?php echo HTMLHelper::_('bootstrap.endAccordion'); ?>


			<input type="hidden" name="task" value="">
			<?php echo HTMLHelper::_('form.token'); ?>
		</div>
		<div id="customize-footer-actions" class="xiro-overlay-footer">
			<button type="button" class="collapse-sidebar button" aria-expanded="true" aria-label="Hide Controls">
				<i class="fa fa-chevron-left"></i>
				<span class="collapse-sidebar-label"><?php echo JText::_('TPL_XIROADMIN_COM_TEMPLATES_TEMPLATE_EDIT_PANEL_SHOW_HIDE'); ?></span>
			</button>
			<div class="devices-wrapper">
				<div class="devices">
					<button type="button" class="preview-desktop" aria-pressed="1" data-device="desktop">
						<span class="icon-screen">&nbsp;</span>
					</button>
					<button type="button" class="preview-tablet" aria-pressed="" data-device="tablet">
						<span class="icon-tablet">&nbsp;</span>
					</button>
					<button type="button" class="preview-mobile" aria-pressed="" data-device="mobile">
						<span class="icon-mobile">&nbsp;</span>
					</button>
				</div>
			</div>
			<div class="panelcontrols-wrapper">
				<div class="panelcontrols">
					<button type="button" class="panelsize" data-size="normal" >
						<span class="icon-expand-2">&nbsp;</span>
					</button>
				</div>
			</div>
		</div>
	</form>
	<div id="xiro-customize-preview" class="">
	</div>
</div>
