<?php
/**
 * @package    Xiroweb Multi Editor with many column
 *
 * @author     Xiroweb <support@xiroweb.com>
 * @copyright  Copyright (c)2021 Xiroweb All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.xiroweb.com
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\Utilities\ArrayHelper;
use Joomla\Database\ParameterType;
use Joomla\CMS\Table\Table;


class mod_InstallerScript
{

	public function install(InstallerAdapter $adapter)
	{
		$element  = 'mod_';

		$clientId = '0';

		$type = 'module';
	
		$db   = Factory::getDbo();


		$query = $db->getQuery(true);

		$query
			->select($db->quoteName('id'))
			->from($db->quoteName('#__modules'))
			->where($db->quoteName('module') . ' = :element')
			->where($db->quoteName('client_id') . ' = :client_id')
			->bind(':element', $element, ParameterType::STRING)
			->bind(':client_id', $clientId, ParameterType::INTEGER);
		$db->setQuery($query);

		try
		{
			$modules = $db->loadColumn();
		}
		catch (\RuntimeException $e)
		{
			$modules = [];
		}

		if (\count($modules))
		{
			// Ensure the list is sane
			$modules = ArrayHelper::toInteger($modules);
			$modID = implode(',', $modules);

			// Wipe out any items assigned to menus
			$query = $db->getQuery(true)
				->delete($db->quoteName('#__modules_menu'))
				->where($db->quoteName('moduleid') . ' IN (' . $modID . ')');
			$db->setQuery($query);

			try
			{
				$db->execute();
			}
			catch (\RuntimeException $e)
			{
				Log::add(Text::sprintf('JLIB_INSTALLER_ERROR_MOD_UNINSTALL_EXCEPTION', $e->getMessage()), Log::WARNING, 'jerror');
				$retval = false;
			}

			// Wipe out any instances in the modules table
			/** @var \Joomla\CMS\Table\Module $module */
			$module = Table::getInstance('Module');

			foreach ($modules as $modInstanceId)
			{
				$module->load($modInstanceId);

				if (!$module->delete())
				{
					Log::add(Text::sprintf('JLIB_INSTALLER_ERROR_MOD_UNINSTALL_EXCEPTION', $module->getError()), Log::WARNING, 'jerror');
					$retval = false;
				}
			}
		}

		$extension = Table::getInstance('extension');
		$extension->load(array('element' => $element, 'type' => $type));
		$extension->enabled = 0;
		$extension->store();

		return true;

	}


}
