<?php
/**
 * @package    Xiroweb Simple Slide
 *
 * @author     Xiroweb <support@xiroweb.com>
 * @copyright  Copyright (c)2021 Xiroweb All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.xiroweb.com
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Layout\LayoutHelper;

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wr = $wa->getRegistry();
$wr->addRegistryFile('media/mod_xiroweb_simpleslide/joomla.asset.json');
$wa->useStyle('mod_xiroweb_simpleslide.swiper');
$wa->useStyle('mod_xiroweb_simpleslide.xirosimpleslide');
$wa->useScript('mod_xiroweb_simpleslide.swiper');

$script = '
	(function(){
		document.addEventListener(\'DOMContentLoaded\', function() {
			var xirosimpleslide'.$module->id .' = new Swiper(".xirosimpleslide-'.$module->id .'", {
	        spaceBetween: 30,
	        effect: "'. $params->get('effect', 'cube') .'",';

	if ($params->get('autoplay', 1)) {
			$script .= 'autoplay: {
				          delay: 2500,
				          disableOnInteraction: false,
				        },';
	}
	if ($params->get('buttonleftright', 1)) {
			$script .=	'navigation: {
				          nextEl: ".swiper-button-next",
				          prevEl: ".swiper-button-prev",
				        },';
	}
	if ($params->get('buttonbottom', 1)) {
			$script .=	'pagination: {
				          el: ".swiper-pagination",
				          clickable: true,
				        },';
	}
$script .=  '});
	    })
	  })();  
';
$wa->addInlineScript($script, [], []);

?>

    <div class="swiper-container xirosimpleslide xirosimpleslide-<?php echo $module->id; ?>">
      <div class="swiper-wrapper">
    	<?php foreach ($slides as $item) { ?>
            <?php if (!empty($item->imageslide)) : ?>
                        <?php 
                            $imglayoutAttr = [
                                'src' => $item->imageslide,
                                'alt' => !empty($item->image_alt) ? htmlspecialchars($item->image_alt, ENT_QUOTES, 'UTF-8') : '',
                            ];
                        ?>
            <?php else: continue; ?>
            <?php endif; ?>
			<div class="swiper-slide">
                <?php if (empty($item->link)) : ?>
                    <?php echo LayoutHelper::render('joomla.html.image', $imglayoutAttr); ?>
                <?php else: ?>
                    <a class="link_img" href="<?php echo htmlspecialchars($item->link, ENT_QUOTES, 'UTF-8'); ?>">
                    <?php echo LayoutHelper::render('joomla.html.image', $imglayoutAttr); ?>
                    </a>
                <?php endif; ?> 
			</div>
		<?php } ?>
      </div>
      <?php if ($params->get('buttonleftright', 1)) : ?>
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
      <?php endif; ?>
      <?php if ($params->get('buttonbottom', 1)) : ?>
      <div class="swiper-pagination"></div>
      <?php endif; ?>
    </div>

