<?php

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

extract($displayData);

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();

$wr = $wa->getRegistry();
$wr->addRegistryFile('media/mod_xiroweb_articles_listing_vertical/joomla.asset.json');

$document = Factory::getApplication()->getDocument();
$document->addScriptOptions('ajaxurl', Uri::root());

$wa->useScript('xiroweb.handlebars');
$wa->useScript('mod_xiroweb_articles_listing_vertical.uipreivewadmin');
$wa->useStyle('xiroweb.xcard');

$style = ' 
    .warp-preview {
        background: #3c3c3c;
        margin-bottom: 3rem;
    }
    .area-preview {
        background-color: #ffffff;
    }
    [data-bs-theme=light] .area-preview {
    --blue: #0d6efd;
    --indigo: #6610f2;
    --purple: #6f42c1;
    --pink: #d63384;
    --red: #dc3545;
    --orange: #fd7e14;
    --yellow: #ffc107;
    --green: #198754;
    --teal: #20c997;
    --cyan: #0dcaf0;
    --black: #000;
    --white: #fff;
    --gray: #6c757d;
    --gray-dark: #343a40;
    --gray-100: #f8f9fa;
    --gray-200: #e9ecef;
    --gray-300: #dee2e6;
    --gray-400: #ced4da;
    --gray-500: #adb5bd;
    --gray-600: #6c757d;
    --gray-700: #495057;
    --gray-800: #343a40;
    --gray-900: #212529;
    --primary: #0d6efd;
    --secondary: #6c757d;
    --success: #198754;
    --info: #0dcaf0;
    --warning: #ffc107;
    --danger: #dc3545;
    --light: #f8f9fa;
    --dark: #212529;
    --primary-rgb: 13, 110, 253;
    --secondary-rgb: 108, 117, 125;
    --success-rgb: 25, 135, 84;
    --info-rgb: 13, 202, 240;
    --warning-rgb: 255, 193, 7;
    --danger-rgb: 220, 53, 69;
    --light-rgb: 248, 249, 250;
    --dark-rgb: 33, 37, 41;
    --primary-text-emphasis: #052c65;
    --secondary-text-emphasis: #2b2f32;
    --success-text-emphasis: #0a3622;
    --info-text-emphasis: #055160;
    --warning-text-emphasis: #664d03;
    --danger-text-emphasis: #58151c;
    --light-text-emphasis: #495057;
    --dark-text-emphasis: #495057;
    --primary-bg-subtle: #cfe2ff;
    --secondary-bg-subtle: #e2e3e5;
    --success-bg-subtle: #d1e7dd;
    --info-bg-subtle: #cff4fc;
    --warning-bg-subtle: #fff3cd;
    --danger-bg-subtle: #f8d7da;
    --light-bg-subtle: #fcfcfd;
    --dark-bg-subtle: #ced4da;
    --primary-border-subtle: #9ec5fe;
    --secondary-border-subtle: #c4c8cb;
    --success-border-subtle: #a3cfbb;
    --info-border-subtle: #9eeaf9;
    --warning-border-subtle: #ffe69c;
    --danger-border-subtle: #f1aeb5;
    --light-border-subtle: #e9ecef;
    --dark-border-subtle: #adb5bd;
    --white-rgb: 255, 255, 255;
    --black-rgb: 0, 0, 0;
    --body-color: #212529;
    --body-color-rgb: 33, 37, 41;
    --body-bg: #fff;
    --body-bg-rgb: 255, 255, 255;
    --emphasis-color: #000;
    --emphasis-color-rgb: 0, 0, 0;
    --secondary-color: rgba(33, 37, 41, 0.75);
    --secondary-color-rgb: 33, 37, 41;
    --secondary-bg: #e9ecef;
    --secondary-bg-rgb: 233, 236, 239;
    --tertiary-color: rgba(33, 37, 41, 0.5);
    --tertiary-color-rgb: 33, 37, 41;
    --tertiary-bg: #f8f9fa;
    --tertiary-bg-rgb: 248, 249, 250;
    --heading-color: inherit;
    --link-color: #0d6efd;
    --link-color-rgb: 13, 110, 253;
    --link-decoration: underline;
    --link-hover-color: #0a58ca;
    --link-hover-color-rgb: 10, 88, 202;
    --code-color: #d63384;
    --highlight-color: #212529;
    --highlight-bg: #fff3cd;
    --border-width: 1px;
    --border-style: solid;
    --border-color: #dee2e6;
    --border-color-translucent: rgba(0, 0, 0, 0.175);
    --border-radius: 0.375rem;
    --border-radius-sm: 0.25rem;
    --border-radius-lg: 0.5rem;
    --border-radius-xl: 1rem;
    --border-radius-xxl: 2rem;
    --border-radius-2xl: var(--border-radius-xxl);
    --border-radius-pill: 50rem;
    
    --xcard-body-bg: #FFFFFF;
    }

  ';
  $wa->addInlineStyle($style);

?>
<h1><?php echo Text::_('MOD_XIROWEB_ARTICLES_LISTING_VERTICAL_PREVIEW_FIELD_HEADING'); ?></h1>
<small><?php echo Text::_('MOD_XIROWEB_ARTICLES_LISTING_VERTICAL_PREVIEW_FIELD_NOTE'); ?></small>

<div class="warp-preview p-1 p-sm-4" data-bs-theme="light">
    <div id="articles-listing-area-preview" class="area-preview"></div>
</div>

<script id="articles-listing-vertical-template-preview" type="text/x-handlebars-template">
<style>

        .area-preview .xcard {
            --bs-xcard-bg: #fafafa;
            --bs-xcard-spacer-y: 0;
            --bs-xcard-spacer-x: 0;
            --bs-xcard-border-radius: {{border_radius}}px;
            --bs-xcard-inner-border-radius: {{image_radius}}px;
            --link-fontweight: {{link_titles_fontweight}};
            --bs-xcard-padding-x: {{item_padding_x}}px;
            --bs-xcard-padding-y: {{item_padding_y}}px;
            --bs-xcard-margin-y: {{item_margin_y}}px;
            --bs-xcard-margin-x: {{item_margin_x}}px;
            {{border_item_css}}
        }
        .area-preview .col-media {
            flex: none;
            width: {{image_width}}%;
        }

        {{#if custom_color_item}}
        .area-preview .xcard {
            --bs-xcard-bg: {{item_background}};
            --bs-xcard-border-color: {{item_border_color}};
            }
        {{/if}}

        {{#if custom_color_text}}
            .area-preview .xcard {
            --bs-xcard-title-color: {{item_title_color}};
            --bs-xcard-color: {{item_text_content_color}};
            }
            .area-preview .xcard-title   {
                --bs-link-color: {{item_title_link_color}};
                --link-color: {{item_title_link_color}};
                --bs-link-hover-color: {{item_title_link_hover_color}};
                --link-hover-color: {{item_title_link_hover_color}};
            }
        {{/if}}
    
</style>

{{{htmlmodule}}}
</script>

