(() => {
    const setBubble = ({target}) => {
        const self = target;
        const val = self.value;
        const min = self.min ? self.min : 0;
        const max = self.max ? self.max : 100;
        const newVal = Number(((val - min) * 100) / (max - min));

        // Create bubble if it doesn't exist
        let bubble = self.nextElementSibling;
        if (!bubble || !bubble.classList.contains('range-value')) {
            bubble = document.createElement('div');
            bubble.className = 'range-value';
            const span = document.createElement('span');
            bubble.appendChild(span);
            self.parentNode.insertBefore(bubble, self.nextSibling);
        }

        // Update bubble position and value
        const span = bubble.querySelector('span');
        span.textContent = `${val}%`;
        bubble.style.left = `calc(${newVal}% + (${8 - newVal * 0.15}px))`;
    };

    const updateUiRangeValue = () => {
        document.querySelectorAll('input[type="range"].form-range').forEach(rangeInput => {
            // Create wrapper if needed
            if (!rangeInput.parentElement.classList.contains('range-wrap')) {
                const wrapper = document.createElement('div');
                wrapper.className = 'range-wrap';
                rangeInput.parentNode.insertBefore(wrapper, rangeInput);
                wrapper.appendChild(rangeInput);
            }

            // Set initial value
            setBubble({target: rangeInput});

            // Add input listener
            rangeInput.addEventListener('input', setBubble);
        });

        // Cleanup
        document.removeEventListener('DOMContentLoaded', updateUiRangeValue, true);
    };

    document.addEventListener('DOMContentLoaded', updateUiRangeValue, true);
})();
