Handlebars.registerHelper('eq', function(a, b) {
    return a === b;
});
const allowList = {
    article: ['class', 'itemscope', 'itemtype'],
    figure: ['class'],
    dl: ['class'],
    dd: ['class'],
    dt: ['class']
  };
window.addEventListener('load', () => {
    let template = (() => {
        const source = document.getElementById('articles-listing-vertical-template-preview')?.innerHTML;
        return source ? Handlebars.compile(source) : null;
    })();
    const samplehtmlmodule = '<h1>Loading</h1>';
    let htmlmodule;
    const subformSelector = document.querySelector('joomla-field-subform[name="jform[params][included_articles]"]');

    const stoplinknavigate = () => {
        const area_preview = document.getElementById('articles-listing-area-preview');
        area_preview.querySelectorAll('a').forEach(link => {
            link.addEventListener('click', function(event) {
                event.preventDefault(); // Stops the link from navigating
            });
        });
    };

    const updateModData = () => {
        // backend and frontend
        const formModule = document.getElementById('module-form') || document.getElementById('modules-form');
        if (!formModule) { return;}

        const baseurlajax = Joomla.getOptions('ajaxurl', '');
    
        const postData = new FormData(formModule);
        Joomla.request({
            url: baseurlajax + 'index.php?option=com_ajax&module=xiroweb_articles_listing_vertical&method=htmlModRender&format=json',
            data: postData,
            method: 'POST',
            perform: true,
            onSuccess: rawJson => {
              try {
                // If we can decode the response as JSON step through the update
                const datamodrequest = JSON.parse(rawJson);
                htmlmodule = Joomla.sanitizeHtml(datamodrequest.data, allowList);
                handleUpdate();
                stoplinknavigate();
              } catch (e) {
                htmlmodule = Joomla.sanitizeHtml(samplehtmlmodule);
              }
            },
            // onError: Joomla.Update.handleErrorResponse
          });
    }

    const getDataContext = () => {
        let context = { 
            htmlmodule: htmlmodule,
            border_item: +document.querySelector('input[name="jform[params][border_item]"]:checked').value,
            border_width: document.getElementById('jform_params_border_width').value,
            border_radius: document.getElementById('jform_params_border_radius').value,
            item_margin_x: document.getElementById('jform_params_item_margin_x').value,
            item_margin_y: document.getElementById('jform_params_item_margin_y').value,
            item_padding_x: document.getElementById('jform_params_item_padding_x').value,
            item_padding_y: document.getElementById('jform_params_item_padding_y').value,
            custom_color_item: +document.querySelector('input[name="jform[params][custom_color_item]"]:checked').value,
            item_border_color: document.getElementById('jform_params_item_border_color').value,       
            item_background: document.getElementById('jform_params_item_background').value,
            image_radius: document.getElementById('jform_params_image_radius').value,
            link_titles_fontweight: +document.querySelector('input[name="jform[params][link_titles_fontweight]"]:checked').value,
            custom_color_text: +document.querySelector('input[name="jform[params][custom_color_text]"]:checked').value,
            item_title_link_color: document.getElementById('jform_params_item_title_link_color').value,
            item_title_color: document.getElementById('jform_params_item_title_color').value,
            item_title_link_hover_color: document.getElementById('jform_params_item_title_link_hover_color').value, 
            item_text_content_color: document.getElementById('jform_params_item_text_content_color').value,
            image_width: document.getElementById('jform_params_image_width').value,
            border_item_css: '',
        };

        switch (context.border_item) {
            case 0:
                context.border_item_css = '--bs-xcard-border-width: 0;';
                break;
            case 1:
                context.border_item_css = '--bs-xcard-border-width: ' + context.border_width + 'px;';
                break;
            case 2:
                context.border_item_css = '--bs-xcard-border-width: ' + context.border_width + 'px 0 0 0;';
                break;
            case 3:
                context.border_item_css  = '--bs-xcard-border-width: 0 ' + context.border_width + 'px 0 0;';
                break;
            case 4:
                context.border_item_css      = '--bs-xcard-border-width: 0 0 ' + context.border_width + 'px 0;';
                break;
            case 5:
                context.border_item_css      = '--bs-xcard-border-width: 0 0 0 ' + context.border_width + 'px;';
                break;
        }
        return context;
    }

    function convertToRelativePath(fullUrl) {
        return fullUrl.replace(/^.*\/images\//, 'images/');
    }

    const imagesrc = () => {
        const area_preview = document.getElementById('articles-listing-area-preview');
        area_preview.querySelectorAll("img").forEach(img => {
            img.src = Joomla.getOptions('system.paths').rootFull + convertToRelativePath(img.src);
        });
    }

    const updateTemplate = (datac) => {
        if (!template) return;
        document.getElementById('articles-listing-area-preview').innerHTML = template(datac);
    };

    // onevent: Boolean 
    const handleUpdate = () => {
        let datacontext = getDataContext();
        updateTemplate(datacontext);
        imagesrc();
    };

    let debounceTimer;
        function debouncedUpdate(callback) {
            clearTimeout(debounceTimer);
            debounceTimer = setTimeout(() => {
                callback();
            }, 50);
        }

    const init = () => {
        const formModule = document.getElementById('module-form') || document.getElementById('modules-form');
        if (!formModule) { return;}
        htmlmodule = Joomla.sanitizeHtml(samplehtmlmodule, allowList);
        handleUpdate();
        stoplinknavigate();
        updateModData();
    }
    
    init();

    ['jform_params_item_background',
    'jform_params_item_border_color',
    'jform_params_item_title_color',
    'jform_params_item_text_content_color',
    'jform_params_item_title_link_color',
    'jform_params_item_title_link_hover_color',
    ].forEach(id => {
        let element = document.getElementById(id);
            ['input', 'change', 'coloris:pick'].forEach(eventType => {
                element.addEventListener(eventType, (event) => {
                    debouncedUpdate(handleUpdate);
                }
            );
        });
    });

    [
    'jform_params_border_item',
    'jform_params_border_width',
    'jform_params_border_radius',
    'jform_params_item_margin_x',
    'jform_params_item_margin_y',
    'jform_params_item_padding_x',
    'jform_params_item_padding_y',
    'jform_params_custom_color_item',
    'jform_params_image_radius',
    'jform_params_custom_color_text',
    ].forEach(id => {
        document.getElementById(id).addEventListener('change', () => {
            handleUpdate();
        });
    });


    [
    'jform_params_switchmode',
    'jform_params_count',
    'jform_params_catid',
    'jform_params_show_child_category_articles',
    'jform_params_levels',
    'jform_params_rowgap',
    'jform_params_item_align',
    'jform_params_image_width',
    'jform_params_image_align',
    'jform_params_img_intro_full',
    'jform_params_link_image',
    'jform_params_text_align',
    'jform_params_item_title',
    'jform_params_item_heading',
    'jform_params_link_titles',
    'jform_params_link_titles_fontweight',
    'jform_params_show_introtext',
    'jform_params_introtext_limit',
    'jform_params_image',
    'jform_params_show_author',
    'jform_params_show_hits',
    'jform_params_show_tags',
    'jform_params_show_category',
    'jform_params_show_category_link',
    'jform_params_show_date',
    'jform_params_show_date_field',
    'jform_params_show_date_format',
    'jform_params_trigger_events',
    'jform_params_show_readmore',
    'jform_params_show_readmore_title',
    'jform_params_readmore_limit',
    'jform_params_show_featured',
    'jform_params_show_archived',
    'jform_params_created_by',
    'jform_params_author_alias_filtering_type',
    'jform_params_created_by_alias',
    'jform_params_date_filtering',
    'jform_params_date_field',
    'jform_params_start_date_range',
    'jform_params_end_date_range',
    'jform_params_relative_date',
    'jform_params_article_ordering',
    'jform_params_article_ordering_direction',
    'jform_params_filter_tag'
    ].forEach(id => {
        document.getElementById(id).addEventListener('change', () => {
            updateModData();
        });
    });

    ['click', 'change', 'dragend'].forEach(eventType => {
        subformSelector.addEventListener(eventType, (event) => {
                const buttonAdd = subformSelector.getAttribute('button-add');
                if (event.target.closest(`${buttonAdd}`)) {
                    return;
                }
                updateModData();
            }
        );
    });
     
});