<?php

/**
 * mod_xiroweb_articles_listing_vertical
 *
 * @copyright   (C) 2024 XiroWeb. <https://www.xiroweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\Service\Provider\HelperFactory;
use Joomla\CMS\Extension\Service\Provider\Module;
use Joomla\CMS\Extension\Service\Provider\ModuleDispatcherFactory;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

/**
 * The mod_xiroweb_articles_listing_vertical module service provider.
 *
 * @since  5.2.0
 */
return new class () implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     */
    public function register(Container $container)
    {
        $container->registerServiceProvider(new ModuleDispatcherFactory('\\Xiroweb\\Module\\XirowebArticlesListingVertical'));
        $container->registerServiceProvider(new HelperFactory('\\Xiroweb\\Module\\XirowebArticlesListingVertical\\Site\\Helper'));

        $container->registerServiceProvider(new Module());
    }
};
