<?php

/**
 * @copyright	Copyright (C) 2020 by XiroWeb
 * @license		GNU/GPL
 * */

namespace Xiroweb\Module\XirowebArticlesListingVertical\Site\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;


class ButtonxiroField extends FormField {

	protected $type = 'buttonxiro';

    protected $layout = 'field.buttonxiro.button';

    protected $basePath = JPATH_SITE . '/modules/' . 'mod_xiroweb_articles_listing_vertical' . '/layouts';


    protected function getLabel()
    {
        if ($this->hidden) {
            return '';
        }

        $data = $this->getLayoutData();

        return $data['label'];
    }

    protected function getTitle()
	{
		return $this->getLabel();
	}

    protected function getRenderer($layoutId = 'default')
	{
		$renderer = new FileLayout($layoutId, $this->basePath);

		$renderer->setDebug($this->isDebugEnabled());

		return $renderer;
	}

}
