<?php

/**
 * @copyright	Copyright (C) 2020 by XiroWeb
 * @license		GNU/GPL
 * */
// no direct access

namespace Xiroweb\Module\XirowebArticlesListingVertical\Site\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Form\FormHelper;

defined('_JEXEC') or die('Restricted access');

class UipreviewField extends FormField {

    protected $type = 'uipreview';

    protected $renderLayout = 'field.uipreview.renderlayout';

    protected $renderLabelLayout = 'field.uipreview.fieldpreview';

    protected $basePath = JPATH_SITE . '/modules/' . 'mod_xiroweb_articles_listing_vertical' . '/layouts';

    protected function getInput()
    {
        return ' ';
    }

    protected function getLabel() {
        $data = $this->getLayoutData();

        // Here mainly for B/C with old layouts. This can be done in the layouts directly
        $extraData = array(
            'text'        => $data['label'],
            'classes'     => explode(' ', $data['labelclass']),
        );

        return $this->getRenderer($this->renderLabelLayout)->render(array_merge($data, $extraData));
    }

    protected function getTitle()
    {
        return $this->getLabel();
    }

    public function renderField($options = array())
    {
        return parent::renderField($options);
    }

    protected function getRenderer($layoutId = 'default')
    {
        $renderer = new FileLayout($layoutId, $this->basePath);

        $renderer->setDebug($this->isDebugEnabled());

        return $renderer;
    }
   
}
