<?php

/**
 * @copyright   (C) 2024 XiroWeb. <https://www.xiroweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Factory;

$baseLayoutPath = JPATH_SITE . '/modules' . '/mod_xiroweb_articles_listing_vertical' . '/layouts';
$blockid = 'art-listing-' . $module->id; 

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wr = $wa->getRegistry();
$wr->addRegistryFile('media/mod_xiroweb_articles_listing_vertical/joomla.asset.json');
$wa->useStyle('xiroweb.xcard');

$style_css = '';

$border_width = $params->get('border_width', '1');
$border_item = $params->get('border_item', '0');
switch ($border_item) {
    case '0':
        $border_item_css = '--bs-xcard-border-width: 0;';
        break;
    case '1':
        $border_item_css = '--bs-xcard-border-width: ' . $border_width . 'px;';
        break;
    case '2':
        $border_item_css = '--bs-xcard-border-width:  ' . $border_width . 'px 0 0 0;';
        break;
    case '3':
        $border_item_css = '--bs-xcard-border-width: 0 ' . $border_width . 'px 0 0;';
        break;
    case '4':
        $border_item_css = '--bs-xcard-border-width: 0 0 ' . $border_width . 'px 0;';
        break;
    case '5':
        $border_item_css = '--bs-xcard-border-width: 0 0 0 ' . $border_width . 'px;';
        break;
}

$style_css .= '#'. $blockid . ' .xcard{'
        . '--bs-xcard-bg: #fafafa;'
        . '--bs-xcard-spacer-y: 0;'
        . '--bs-xcard-spacer-x: 0;'
        . '--bs-xcard-border-radius:  ' . $params->get('border_radius') . 'px;'
        . '--bs-xcard-inner-border-radius: ' . $params->get('image_radius') . 'px;'
        . '--link-fontweight: ' . $params->get('link_titles_fontweight'). ';'
        . '--bs-xcard-padding-y: ' . $params->get('item_padding_y'). 'px;'
        . '--bs-xcard-padding-x: ' . $params->get('item_padding_x'). 'px;'
        . '--bs-xcard-margin-y: ' . $params->get('item_margin_y'). 'px;'
        . '--bs-xcard-margin-x: ' . $params->get('item_margin_x'). 'px;'
        . $border_item_css
        . '}' 
        . '#'. $blockid . ' .col-media { flex: none; width: '.$params->get('image_width').'%;}'
        ;

if ($params->get('custom_color_item', '0')) {  
    $style_css .=  '#'. $blockid . ' .xcard{'
        . '--bs-xcard-bg: ' . $params->get('item_background'). ';'
        . '--bs-xcard-border-color: ' . $params->get('item_border_color'). ';'
        . '}' ;
}

if ($params->get('custom_color_text', '0')) {
    $style_css .=  '#'. $blockid . ' .xcard{'
        . '--bs-xcard-title-color: ' . $params->get('item_title_color'). ';'
        . '--bs-xcard-color: ' . $params->get('item_text_content_color'). ';'
        . '}' 
        .'#'. $blockid . ' .xcard-title  {'
        . '--bs-link-color: '. $params->get('item_title_link_color') . ';'
        . '--link-color: '. $params->get('item_title_link_color') . ';'
        . '--bs-link-hover-color: '. $params->get('item_title_link_hover_color') . ';'
        . '--link-hover-color: '. $params->get('item_title_link_hover_color') . ';'
        . '}' ;
}

if (!empty($style_css)) {
    $wa->addInlineStyle($style_css);
}

?>
<div id="<?php echo $blockid ?>">
        <?php foreach ($items as $item) : ?>
            <?php
            $displayInfo = $item->displayHits || $item->displayAuthorName || $item->displayCategoryTitle || $item->displayDate;
            ?>
                <article class="xcard text-<?php echo $params->get('text_align', 'start'); ?>" itemscope itemtype="https://schema.org/Article">
                    <div class="row g-<?php echo $params->get('rowgap', '2');  ?> align-items-<?php echo $params->get('item_align', 'start'); ?>">
                        <div class="col-media order-<?php echo $params->get('image_align', '0'); ?>">
                            <?php if (in_array($params->get('img_intro_full'), ['intro', 'full']) && !empty($item->imageSrc)) : ?>
                                <?php 
                                $images  = json_decode($item->images);
                                if ($params->get('img_intro_full') == 'intro') {
                                    $layoutAttr = [
                                        'src' => $images->image_intro,
                                        'alt' => empty($images->image_intro_alt) && empty($images->image_intro_alt_empty) ? false : $images->image_intro_alt,
                                    ];
                                }
                                if ($params->get('img_intro_full') == 'full') {
                                    $layoutAttr = [
                                        'src' => $images->image_fulltext,
                                        'alt' => empty($images->image_fulltext_alt) && empty($images->image_fulltext_alt_empty) ? false : $images->image_fulltext_alt,
                                    ];
                                }
                                $layoutAttr['class'] = 'xcard-img';
                                ?>
                            <?php $imagerender = LayoutHelper::render('joomla.html.image', $layoutAttr); ?>
                            <?php if ($params->get('link_image') == 1) : ?>
                                <?php $attributes = ['class' => 'image-link ' . $item->active, 'itemprop' => 'url']; ?>
                                <?php $link = htmlspecialchars($item->link, ENT_COMPAT, 'UTF-8', false); ?>
                                <?php echo HTMLHelper::_('link', $link, $imagerender, $attributes); ?>
                            <?php else : ?>
                                <?php echo $imagerender; ?>
                            <?php endif; ?>
                            <?php endif; ?>
                        </div>

                    <?php if ($params->get('item_title') || $displayInfo || $params->get('show_tags') || $params->get('show_introtext') || $params->get('show_readmore')) : ?>
                        <div class="col ">
                        <div class="xcard-body ">
                            <?php if ($params->get('item_title')) : ?>
                                <?php $item_heading = $params->get('item_heading', 'h4'); ?>
                                <<?php echo $item_heading; ?> class="xcard-title" itemprop="name">
                                    <?php if ($params->get('link_titles') == 1) : ?>
                                        <?php $attributes = ['class' => 'xcard-title-link ' . $item->active, 'itemprop' => 'url']; ?>
                                        <?php $link = htmlspecialchars($item->link, ENT_COMPAT, 'UTF-8', false); ?>
                                        <?php $title = htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8', false); ?>
                                        <?php echo HTMLHelper::_('link', $link, $title, $attributes); ?>
                                    <?php else : ?>
                                        <?php echo $item->title; ?>
                                    <?php endif; ?>
                                </<?php echo $item_heading; ?>>
                            <?php endif; ?>

                            <?php echo $item->event->afterDisplayTitle; ?>

                            <?php if ($displayInfo) : ?>
                                <?php $listClass = ''; ?>
                                <div class="<?php echo $listClass; ?>">
                                    <?php if ($item->displayAuthorName) : ?>
                                        <span class="badge bg-light text-dark border m-1 ms-0 fw-light fs-small-1">
                                            <?php echo LayoutHelper::render('joomla.icon.iconclass', ['icon' => 'icon-user icon-fw']); ?>
                                            <?php echo $item->displayAuthorName; ?>
                                        </span>
                                    <?php endif; ?>

                                    <?php if ($item->displayCategoryTitle) : ?>
                                        <span class="badge bg-light text-dark border m-1 ms-0 fw-light fs-small-1">
                                            <?php echo LayoutHelper::render('joomla.icon.iconclass', ['icon' => 'icon-folder-open icon-fw']); ?>
                                            <?php if ($item->displayCategoryLink) : ?>
                                                <a class="text-bg-light" href="<?php echo $item->displayCategoryLink; ?>">
                                                    <?php echo $item->displayCategoryTitle; ?>
                                                </a>
                                            <?php else : ?>
                                                <?php echo $item->displayCategoryTitle; ?>
                                            <?php endif; ?>
                                        </span>
                                    <?php endif; ?>

                                    <?php if ($item->displayDate) : ?>
                                        <span class="badge bg-light text-dark border m-1 ms-0 fw-light fs-small-1">
                                            <?php echo LayoutHelper::render('joomla.icon.iconclass', ['icon' => 'icon-calendar icon-fw']); ?>
                                            <?php echo $item->displayDate; ?>
                                        </span>
                                    <?php endif; ?>

                                    <?php if ($item->displayHits) : ?>
                                        <span class="badge bg-light text-dark border m-1 ms-0 fw-light fs-small-1">
                                            <?php echo LayoutHelper::render('joomla.icon.iconclass', ['icon' => 'icon-eye icon-fw']); ?>
                                            <?php echo Text::_('MOD_XIROWEB_ARTICLES_LISTING_VERTICAL_VIEWS'); ?> <?php echo $item->displayHits; ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <?php echo $item->event->beforeDisplayContent; ?>

                            <?php if ($params->get('show_introtext', 1)) : ?>
                                <?php echo $item->displayIntrotext; ?>
                            <?php endif; ?>

                            <?php echo $item->event->afterDisplayContent; ?>

                            <?php if ($params->get('show_tags', 0) && $item->tags->itemTags) : ?>
                                <div class="contenttags">
                                    <?php $item->params->set('tag_link_class', 'btn-info btn-sm'); ?>
                                    <?php echo LayoutHelper::render('joomla.content.tags', $item->tags->itemTags); ?>
                                </div>
                            <?php endif; ?>

                            <?php if ($params->get('show_readmore')) : ?>
                                <?php if ($params->get('show_readmore_title', '') !== '') : ?>
                                    <?php $item->params->set('show_readmore_title', $params->get('show_readmore_title')); ?>
                                    <?php $item->params->set('readmore_limit', $params->get('readmore_limit')); ?>
                                    <?php $item->params->set('readmore_class_css', 'small btn-readmore'); ?>
                                    <?php endif; ?>
                                <?php echo LayoutHelper::render('content.readmore', ['item' => $item, 'params' => $item->params, 'link' => $item->link], $baseLayoutPath); ?>
                            <?php endif; ?>
                        </div>
                        </div>
                    <?php endif; ?>
                    </div>
                </article>
        <?php endforeach; ?>
</div>
