<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_xiroweb_headline_news
 *
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Factory;

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$style = '			
    .mod-xirowweb-headline-news-tags ul.list-inline {
        display: inline-block;
    }
';
$wa->addInlineStyle($style);
?>
<div class="row">
<?php foreach ($items as $item) : ?>
	<?php
		if ($params->get('link_intro_image', 1)) {
			$item->params->set('link_intro_image',true);
		}
		?>

    <div class="col-12">
        <div class="card rounded-0 border-0 border-bottom mb-3">
            <?php if ($params->get('show_image')) : ?>
                <?php 
                    $images  = json_decode($item->images);
                ?>
                <?php if (!empty($images->image_intro)) : ?>
                <?php
                    $imgclass   = empty($images->float_intro) ? $item->params->get('float_intro') : $images->float_intro;
                    $layoutAttr = [
                        'src' => $images->image_intro,
                        'alt' => empty($images->image_intro_alt) && empty($images->image_intro_alt_empty) ? false : $images->image_intro_alt,
                    ];
                ?>
                        <?php if ($item->params->get('link_intro_image') && ($item->params->get('access-view') || $item->params->get('show_noauth', '0') == '1')) : ?>
                            <a href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid, $item->language)); ?>" itemprop="url" title="<?php echo $item->title; ?>">
                            <?php echo LayoutHelper::render('joomla.html.image', array_merge($layoutAttr, ['itemprop' => 'thumbnailUrl', 'class' => 'w-100'])); ?>
                            </a>
                        <?php else : ?>
                            <?php echo LayoutHelper::render('joomla.html.image', array_merge($layoutAttr, ['itemprop' => 'thumbnailUrl', 'class' => 'w-100'])); ?>
                        <?php endif; ?>
                <?php endif; ?>
            <?php endif; ?>
            <div class="card-body">
                <h2>
                    <?php if ($params->get('link_titles') == 1) : ?>
                        <?php $attributes = ['class' => 'mod-articles-category-title ' . $item->active]; ?>
                        <?php $link = htmlspecialchars($item->link, ENT_COMPAT, 'UTF-8', false); ?>
                        <?php $title = htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8', false); ?>
                        <?php echo HTMLHelper::_('link', $link, $title, $attributes); ?>
                    <?php else : ?>
                        <?php echo $item->title; ?>
                    <?php endif; ?>
                </h2>
                <div>
                    <?php if ($item->displayHits) : ?>
                        <span class="badge bg-light text-dark border m-1 ms-0">
                            <i class="fas fa-chart-line"></i>
                            <?php echo Text::_('JGLOBAL_HITS') . ': ' ; ?>
                            <?php echo $item->displayHits; ?>
                        </span>
                    <?php endif; ?>

                    <?php if ($params->get('show_author')) : ?>
                        <span class="badge bg-light text-dark border m-1 ms-0">
                            <i  class="far fa-user"></i>
                            <?php echo Text::_('JAUTHOR') . ': ' ; ?>
                            <?php echo $item->displayAuthorName; ?>
                        </span>
                    <?php endif; ?>

                    <?php if ($item->displayCategoryTitle) : ?>
                        <span class="badge bg-light text-dark border m-1 ms-0">
                            <i  class="fas fa-folder"></i>
                            <?php echo $item->displayCategoryTitle; ?>
                        </span>
                    <?php endif; ?>

                    <?php if ($item->displayDate) : ?>
                        <span class="badge bg-light text-dark border m-1 ms-0">
                            <i class="far fa-calendar-alt"></i>
                            <?php echo Text::_('JGLOBAL_FIELD_CREATED_LABEL') . ': '; ?>
                            <?php echo $item->displayDate; ?>
                        </span>
                    <?php endif; ?>

                    <?php if ($params->get('show_tags', 0) && $item->tags->itemTags) : ?>
                        <div class="mod-xirowweb-headline-news-tags">
                            <i  class="fas fa-tags"></i>
                            <?php echo LayoutHelper::render('joomla.content.tags', $item->tags->itemTags); ?>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if ($params->get('show_introtext')) : ?>
                    <p class="card-text">
                        <?php echo $item->displayIntrotext; ?>
                    </p>
                <?php endif; ?>

                <?php if ($params->get('show_readmore')) : ?>
                    <p class="mod-xiroweb-headline-news-readmore text-end">
                        <a class="btn btn-sm btn-secondary <?php echo $item->active; ?>" href="<?php echo $item->link; ?>">
                            <?php if ($item->params->get('access-view') == false) : ?>
                                <?php echo Text::_('MOD_XIROWEB_HEADLINE_NEWS_REGISTER_TO_READ_MORE'); ?>
                            <?php elseif ($params->get('readmore_title_overide', 0) && (!empty($params->get('readmore_text_overide', '')))) : ?>
                                <?php echo htmlspecialchars($params->get('readmore_text_overide'), ENT_QUOTES, 'UTF-8'); ?>
                            <?php else : ?>
                                <?php echo Text::_('MOD_XIROWEB_HEADLINE_NEWS_READ_MORE_TITLE'); ?>
                            <?php endif; ?>
                        </a>
                    </p>
                <?php endif; ?>
            </div>
        </div>
	</div>
<?php endforeach; ?>
</div>
