<?php

/**
 * @copyright	Copyright (C) 2020 by XiroWeb
 * @license		GNU/GPL
 * */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;

class JFormFieldConfigstyleadmin extends JFormField {

	protected $type = 'configstyleadmin';

	protected function getInput() {

		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();

		$style = ('
                :root, [data-bs-theme=light]{
                    --xiro-ext-input-bg: #ECEFF1;
                }
                [data-bs-theme=dark]{
                    --xiro-ext-input-bg: rgb(48 52 55);
                }
                @media (prefers-color-scheme: dark) { :root {
                    --xiro-ext-input-bg: rgb(48 52 55);

                }}
                .subform-repeatable table{
                    --table-bg: var(--xiro-ext-input-bg);
                }
				@import url("https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap");

				#general {
					padding: 10px;
					border-radius: 12px;
				}
				#general > div[class*="row"] > div:nth-of-type(1) {
					font-family: "Roboto", sans-serif;
					font-size: 120%;
					font-weight: 400;
				}
	
				#general .control-label {
				    float: none;
				    width: auto;
				    padding-right: 0;
				    padding-top: 0;
				    text-align: left;
				}
				#general .control-label > label {
					display: inline-block;
					*display: inline;
					*zoom: 1;
				}
				#general .controls {
					margin-left: 0;
				}
	
				#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(3),
				#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(4),
				#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(5),
				#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(6)
				 {
					display: block;
						
				}

				@media (min-width: 768px) {
					#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(3),
					#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(4),
					#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(5),
					#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(6)
					 {
						display: inline-block;
						width: 20%;
						padding: 10px;
							
					}
				}

				.clearfix {}
				#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(6) {
					*zoom: 1;
				}
				#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(6):before,
				#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(6):after {
					display: table;
					content: "";
					line-height: 0;
				}
				#general > div[class*="row"] > div:nth-of-type(1) > div.control-group:nth-of-type(6):after {
					clear: both;
				}
				.subform-repeatable-group {
					box-shadow: 0 6px 6px rgb(0 0 0 / 7%), 0 6px 6px rgb(0 0 0 / 16%);
					border-radius: 12px;
					padding: 10px;
                    background-color: var(--xiro-ext-input-bg);
					margin-bottom: 20px;
					margin-top: 20px;
				}

				#general > div[class*="row"] > div:nth-of-type(1)  input[type="number"] {
				    font-size: 20px;
				    font-weight: bold;
				    color: var(--body-color);
				    width: inherit;
				}

				#general > div[class*="row"] > div:nth-of-type(1) .chzn-container-single .chzn-single {
					border: 2px solid #2196f3;
				}
				#general > div[class*="row"] > div:nth-of-type(1) .chzn-container .chzn-drop {
					border: 2px solid #2196f3;
				}
				#general > div[class*="row"] > div:nth-of-type(1) .chzn-container .chzn-results {
					font-weight: 700;
					color: var(--body-color);
				}

				#general > div[class*="row"] > div:nth-of-type(1) textarea,
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="text"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="password"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="datetime"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="datetime-local"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="date"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="month"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="time"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="week"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="number"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="email"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="url"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="search"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="tel"],
				#general > div[class*="row"] > div:nth-of-type(1)  input[type="color"],
				#general > div[class*="row"] > div:nth-of-type(1)  .uneditable-input {
					box-shadow: 0 6px 6px rgb(0 0 0 / 7%), 0 6px 6px rgb(0 0 0 / 16%);
                    background-color: var(--xiro-ext-input-bg);
				}
			
		');

		$wa->addInlineStyle($style);
		return '';
	}

	protected function getLabel() {
		return '';
	}
}
