<?php
/**
 * @package    Xiroweb Simple Slide
 *
 * @author     Xiroweb <support@xiroweb.com>
 * @copyright  Copyright (c)2021 Xiroweb All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.xiroweb.com
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();


// Access to module parameters
$script_pros = array();

$script = '
	(function($){
		$(document).ready(function(){

			var xirosimpleslide'.$module->id .' = new Swiper(".xirosimpleslide-'.$module->id .'", {
	        spaceBetween: 30,
	        effect: "'. $params->get('effect', 'cube') .'",';

	if ($params->get('autoplay', 1)) {
			$script .= 'autoplay: {
				          delay: 2500,
				          disableOnInteraction: false,
				        },';
	}
	if ($params->get('buttonleftright', 1)) {
			$script .=	'navigation: {
				          nextEl: ".swiper-button-next",
				          prevEl: ".swiper-button-prev",
				        },';
	}
	if ($params->get('buttonbottom', 1)) {
			$script .=	'pagination: {
				          el: ".swiper-pagination",
				          clickable: true,
				        },';
	}
$script .=  '});
	    })
	  })(jQuery);  
';

$wa->addInlineScript($script, [], []);


$style = '   .swiper-container {
  width: 100%;
  height: 100%;
}

.swiper-slide {
  background-position: center;
  background-size: cover;
}

.swiper-slide img {
  display: block;
  width: 100%;
}';
$wa->addInlineStyle($style);

?>

    <div class="swiper-container xirosimpleslide-<?php echo $module->id; ?>">
      <div class="swiper-wrapper">
    	<?php foreach ($slides as $item) { ?>
			<div class="swiper-slide">
				 <img src="<?php echo $item->imageslide; ?>">
			</div>
		<?php } ?>
      </div>
      <div class="swiper-button-next"></div>
      <div class="swiper-button-prev"></div>
      <div class="swiper-pagination"></div>
    </div>

