document.addEventListener('DOMContentLoaded', () => {
    let groupfieldvalues = [], swiper, template = (() => {
        const source = document.getElementById('swiper-template-preview')?.innerHTML;
        return source ? Handlebars.compile(source) : null;
    })();
    
    const subformSelector = document.querySelector('joomla-field-subform[name="jform[params][group_slide]"]');

    const getSubformValues = row => {
        let values = {};
        row.querySelectorAll('input, select, textarea').forEach(input => values[input.name] = input.value);
        return values;
    };

    const updateSubformValues = container => Array.from(container.querySelectorAll('.subform-repeatable-group')).map(getSubformValues);

    const getSlideImages = fields => fields.map(item => {
        for (let key in item) if (key.includes('[imageslide]')) return item[key];
    }).filter(Boolean);

    const updateTemplate = () => {
        if (!template) return;
        let context = { 
            slides: getSlideImages(groupfieldvalues),
            buttonleftright: !!+document.querySelector('input[name="jform[params][buttonleftright]"]:checked').value,
            buttonbottom: !!+document.querySelector('input[name="jform[params][buttonbottom]"]:checked').value
        };
        document.getElementById('swiper-container-admin-preview').innerHTML = template(context);
        startSwiper();
    };

    const startSwiper = () => {
        let autoplayinput = !!+document.querySelector('input[name="jform[params][autoplay]"]:checked').value;
        let autoplayslide = autoplayinput ? { delay: 2500, disableOnInteraction: false } : false;
        if (swiper) swiper.destroy();
        swiper = new Swiper('.swiper-container-admini-preview', {
            direction: 'horizontal', loop: true,
            pagination: { el: '.swiper-pagination' },
            navigation: { nextEl: '.swiper-button-next', prevEl: '.swiper-button-prev' },
            effect: document.getElementById("jform_params_effect").value, autoplay: autoplayslide
        });
    };

    const handleUpdate = () => {
        groupfieldvalues = updateSubformValues(subformSelector);
        updateTemplate();
    };

    if (subformSelector) {
        handleUpdate();

        ['click', 'change', 'dragend'].forEach(eventType => {
            subformSelector.addEventListener(eventType, handleUpdate);
        });
    }

    ['jform_params_effect', 'jform_params_autoplay', 'jform_params_buttonleftright', 'jform_params_buttonbottom'].forEach(id => {
        document.getElementById(id).addEventListener('change', updateTemplate);
    });
});
